<?php
/**
 * API de verificação de IP - GameServer L2
 * GET ?ip=XXX&name=Servidor (name opcional)
 */

require_once __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate');

$ip = isset($_GET['ip']) ? trim($_GET['ip']) : '';
$name = isset($_GET['name']) ? trim($_GET['name']) : '';

if (empty($ip)) {
    echo json_encode(['authorized' => false, 'error' => 'IP não informado']);
    exit;
}

if (!filter_var($ip, FILTER_VALIDATE_IP)) {
    echo json_encode(['authorized' => false, 'error' => 'IP inválido']);
    exit;
}

$ips = loadIps();
$authorized = in_array($ip, $ips['allowed']) && !in_array($ip, $ips['blocked']);

if ($authorized) {
    recordServerHeartbeat($ip, $name);
}

echo json_encode([
    'authorized' => $authorized,
    'ip' => $ip
]);

function loadIps() {
    $default = ['allowed' => [], 'blocked' => []];
    if (!file_exists(IPS_FILE)) {
        return $default;
    }
    $data = json_decode(file_get_contents(IPS_FILE), true);
    return $data ?: $default;
}

function recordServerHeartbeat($ip, $name) {
    if (!is_dir(DATA_DIR)) {
        mkdir(DATA_DIR, 0755, true);
    }
    $servers = [];
    if (file_exists(SERVERS_FILE)) {
        $servers = json_decode(file_get_contents(SERVERS_FILE), true) ?: [];
    }
    $servers[$ip] = [
        'ip' => $ip,
        'name' => $name ?: 'Servidor ' . $ip,
        'last_check' => time(),
        'updated_at' => date('Y-m-d H:i:s')
    ];
    file_put_contents(SERVERS_FILE, json_encode($servers, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
