<?php
/**
 * Painel de administração - L2Warg Security
 */
require_once dirname(__DIR__) . '/config.php';

$baseUrl = dirname($_SERVER['SCRIPT_NAME']);
if (substr($baseUrl, -1) !== '/') $baseUrl .= '/';
$baseUrl = rtrim($baseUrl, '/admin');

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}

// Login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user'], $_POST['pass'])) {
    if ($_POST['user'] === ADMIN_USER && password_verify($_POST['pass'], ADMIN_PASS)) {
        $_SESSION['l2warg_admin'] = true;
        header('Location: index.php');
        exit;
    }
    $error = 'Usuário ou senha incorretos.';
}

// Verificar autenticação
if (!isset($_SESSION['l2warg_admin']) || !$_SESSION['l2warg_admin']) {
    ?>
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Login - L2Warg Admin</title>
        <style>
            * { box-sizing: border-box; }
            body { font-family: 'Segoe UI', sans-serif; background: #1a1d23; color: #e4e4e7; min-height: 100vh; display: flex; align-items: center; justify-content: center; margin: 0; }
            .login-box { background: #252830; padding: 2rem; border-radius: 8px; width: 320px; box-shadow: 0 4px 20px rgba(0,0,0,0.3); }
            h1 { margin: 0 0 1.5rem; font-size: 1.25rem; text-align: center; color: #f59e0b; }
            input { width: 100%; padding: 0.75rem; margin-bottom: 1rem; border: 1px solid #3f4552; border-radius: 4px; background: #1a1d23; color: #e4e4e7; }
            button { width: 100%; padding: 0.75rem; background: #f59e0b; color: #1a1d23; border: none; border-radius: 4px; font-weight: 600; cursor: pointer; }
            button:hover { background: #d97706; }
            .error { color: #ef4444; font-size: 0.875rem; margin-bottom: 1rem; text-align: center; }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h1>L2Warg Security</h1>
            <?php if (isset($error)): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
            <form method="POST">
                <input type="text" name="user" placeholder="Usuário" required autofocus>
                <input type="password" name="pass" placeholder="Senha" required>
                <button type="submit">Entrar</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Ações via GET (para links simples)
$action = $_GET['action'] ?? '';
$msg = '';

if ($action === 'allow' && isset($_GET['ip'])) {
    $ip = trim($_GET['ip']);
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ips = loadIpsData();
        $ips['allowed'][] = $ip;
        $ips['allowed'] = array_unique($ips['allowed']);
        $ips['blocked'] = array_values(array_diff($ips['blocked'], [$ip]));
        saveIpsData($ips);
        $msg = 'IP ' . htmlspecialchars($ip) . ' permitido.';
    }
}

if ($action === 'block' && isset($_GET['ip'])) {
    $ip = trim($_GET['ip']);
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ips = loadIpsData();
        $ips['blocked'][] = $ip;
        $ips['blocked'] = array_unique($ips['blocked']);
        $ips['allowed'] = array_values(array_diff($ips['allowed'], [$ip]));
        saveIpsData($ips);
        $msg = 'IP ' . htmlspecialchars($ip) . ' bloqueado.';
    }
}

if ($action === 'remove' && isset($_GET['ip'])) {
    $ip = trim($_GET['ip']);
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ips = loadIpsData();
        $ips['allowed'] = array_values(array_diff($ips['allowed'], [$ip]));
        $ips['blocked'] = array_values(array_diff($ips['blocked'], [$ip]));
        saveIpsData($ips);
        $msg = 'IP ' . htmlspecialchars($ip) . ' removido.';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_ip'])) {
    $ip = trim($_POST['new_ip'] ?? '');
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ips = loadIpsData();
        if (!in_array($ip, $ips['allowed'])) {
            $ips['allowed'][] = $ip;
            $ips['allowed'] = array_unique($ips['allowed']);
            $ips['blocked'] = array_values(array_diff($ips['blocked'], [$ip]));
            saveIpsData($ips);
            $msg = 'IP ' . htmlspecialchars($ip) . ' adicionado e permitido.';
        } else {
            $msg = 'IP já está na lista de permitidos.';
        }
    } else {
        $msg = 'IP inválido.';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['rename_server'])) {
    $ip = trim($_POST['server_ip'] ?? '');
    $name = trim($_POST['server_name'] ?? '');
    if (filter_var($ip, FILTER_VALIDATE_IP) && $name) {
        $servers = loadServersData();
        if (isset($servers[$ip])) {
            $servers[$ip]['name'] = $name;
            $servers[$ip]['updated_at'] = date('Y-m-d H:i:s');
            saveServersData($servers);
            $msg = 'Nome do servidor atualizado.';
        }
    }
}

function loadIpsData() {
    $f = dirname(__DIR__) . '/data/ips.json';
    if (!file_exists($f)) return ['allowed' => [], 'blocked' => []];
    $d = json_decode(file_get_contents($f), true);
    return $d ?: ['allowed' => [], 'blocked' => []];
}

function saveIpsData($data) {
    $f = dirname(__DIR__) . '/data/ips.json';
    if (!is_dir(dirname($f))) mkdir(dirname($f), 0755, true);
    file_put_contents($f, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function loadServersData() {
    $f = dirname(__DIR__) . '/data/servers.json';
    if (!file_exists($f)) return [];
    $d = json_decode(file_get_contents($f), true);
    return $d ?: [];
}

function saveServersData($data) {
    $f = dirname(__DIR__) . '/data/servers.json';
    if (!is_dir(dirname($f))) mkdir(dirname($f), 0755, true);
    file_put_contents($f, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$ips = loadIpsData();
$servers = loadServersData();
$now = time();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - L2Warg Security</title>
    <style>
        * { box-sizing: border-box; }
        body { font-family: 'Segoe UI', sans-serif; background: #1a1d23; color: #e4e4e7; margin: 0; padding: 1.5rem; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem; flex-wrap: wrap; gap: 1rem; }
        h1 { color: #f59e0b; margin: 0; font-size: 1.5rem; }
        a { color: #60a5fa; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .logout { color: #94a3b8; font-size: 0.875rem; }
        .card { background: #252830; border-radius: 8px; padding: 1.5rem; margin-bottom: 1.5rem; box-shadow: 0 2px 10px rgba(0,0,0,0.2); }
        .card h2 { margin: 0 0 1rem; font-size: 1.1rem; color: #f59e0b; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #3f4552; }
        th { color: #94a3b8; font-weight: 500; font-size: 0.75rem; text-transform: uppercase; }
        .badge { display: inline-block; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.75rem; font-weight: 600; }
        .badge-online { background: #22c55e; color: #1a1d23; }
        .badge-offline { background: #64748b; color: #e4e4e7; }
        .badge-allowed { background: #22c55e33; color: #22c55e; }
        .badge-blocked { background: #ef444433; color: #ef4444; }
        .actions a { margin-right: 0.5rem; font-size: 0.875rem; }
        .form-inline { display: flex; gap: 0.5rem; margin-bottom: 1rem; flex-wrap: wrap; }
        .form-inline input { flex: 1; min-width: 150px; padding: 0.5rem; border: 1px solid #3f4552; border-radius: 4px; background: #1a1d23; color: #e4e4e7; }
        .btn { padding: 0.5rem 1rem; border: none; border-radius: 4px; cursor: pointer; font-weight: 500; font-size: 0.875rem; text-decoration: none; display: inline-block; }
        .btn-primary { background: #f59e0b; color: #1a1d23; }
        .btn-primary:hover { background: #d97706; }
        .btn-danger { background: #ef4444; color: #fff; }
        .btn-success { background: #22c55e; color: #1a1d23; }
        .msg { padding: 0.75rem; background: #22c55e33; border-radius: 4px; margin-bottom: 1rem; color: #22c55e; }
        .msg.error { background: #ef444433; color: #ef4444; }
        .empty { color: #64748b; font-style: italic; padding: 1rem; }
    </style>
</head>
<body>
    <div class="header">
        <h1>L2Warg Security - Painel Admin</h1>
        <a href="?logout=1" class="logout">Sair</a>
    </div>

    <?php if ($msg): ?><div class="msg"><?= htmlspecialchars($msg) ?></div><?php endif; ?>

    <div class="card">
        <h2>Adicionar IP</h2>
        <form method="POST" class="form-inline">
            <input type="text" name="new_ip" placeholder="Ex: 192.168.1.100" required pattern="[0-9\.]+">
            <button type="submit" name="add_ip" class="btn btn-primary">Permitir IP</button>
        </form>
    </div>

    <div class="card">
        <h2>IPs Permitidos (<?= count($ips['allowed']) ?>)</h2>
        <?php if (empty($ips['allowed'])): ?>
            <div class="empty">Nenhum IP permitido.</div>
        <?php else: ?>
        <table>
            <tr><th>IP</th><th>Ações</th></tr>
            <?php foreach ($ips['allowed'] as $ip): ?>
            <tr>
                <td><span class="badge badge-allowed"><?= htmlspecialchars($ip) ?></span></td>
                <td class="actions">
                    <a href="?action=block&ip=<?= urlencode($ip) ?>" onclick="return confirm('Bloquear este IP?')">Bloquear</a>
                    <a href="?action=remove&ip=<?= urlencode($ip) ?>" onclick="return confirm('Remover da lista?')">Remover</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        <?php endif; ?>
    </div>

    <div class="card">
        <h2>IPs Bloqueados (<?= count($ips['blocked']) ?>)</h2>
        <?php if (empty($ips['blocked'])): ?>
            <div class="empty">Nenhum IP bloqueado.</div>
        <?php else: ?>
        <table>
            <tr><th>IP</th><th>Ações</th></tr>
            <?php foreach ($ips['blocked'] as $ip): ?>
            <tr>
                <td><span class="badge badge-blocked"><?= htmlspecialchars($ip) ?></span></td>
                <td class="actions">
                    <a href="?action=allow&ip=<?= urlencode($ip) ?>">Permitir</a>
                    <a href="?action=remove&ip=<?= urlencode($ip) ?>" onclick="return confirm('Remover da lista?')">Remover</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        <?php endif; ?>
    </div>

    <div class="card">
        <h2>Servidores (Status Online)</h2>
        <p style="color:#94a3b8;font-size:0.875rem;margin:0 0 1rem;">Servidores que verificaram nos últimos <?= ONLINE_THRESHOLD ?> segundos.</p>
        <?php if (empty($servers)): ?>
            <div class="empty">Nenhum servidor registrado ainda. Os servidores aparecem aqui quando fazem a verificação de IP.</div>
        <?php else: ?>
        <table>
            <tr><th>Nome</th><th>IP</th><th>Última verificação</th><th>Status</th><th>Editar nome</th></tr>
            <?php foreach ($servers as $s): 
                $online = ($now - $s['last_check']) <= ONLINE_THRESHOLD;
            ?>
            <tr>
                <td><?= htmlspecialchars($s['name'] ?? 'Servidor ' . $s['ip']) ?></td>
                <td><?= htmlspecialchars($s['ip']) ?></td>
                <td><?= htmlspecialchars($s['updated_at'] ?? date('Y-m-d H:i:s', $s['last_check'])) ?></td>
                <td><span class="badge <?= $online ? 'badge-online' : 'badge-offline' ?>"><?= $online ? 'Online' : 'Offline' ?></span></td>
                <td>
                    <form method="POST" style="display:inline;" onsubmit="return this.server_name.value.trim()">
                        <input type="hidden" name="server_ip" value="<?= htmlspecialchars($s['ip']) ?>">
                        <input type="text" name="server_name" value="<?= htmlspecialchars($s['name'] ?? '') ?>" placeholder="Nome" style="width:120px;padding:0.25rem;margin-right:0.25rem;">
                        <button type="submit" name="rename_server" class="btn btn-primary" style="padding:0.25rem 0.5rem;font-size:0.75rem;">Salvar</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        <?php endif; ?>
    </div>

    <p style="color:#64748b;font-size:0.75rem;">API: <?= htmlspecialchars('https://' . ($_SERVER['HTTP_HOST'] ?? 'security.l2warg.com') . dirname(dirname($_SERVER['SCRIPT_NAME'])) . '/verify_ip.php?ip=XXX') ?></p>
</body>
</html>
